breed [ irish an-irish ]
breed [ english an-english ]

undirected-link-breed [ alliances alliance ]
undirected-link-breed [ wars war ]
directed-link-breed [ alliance-requests alliance-request ]

globals [
power-english ;; sum of the power of all English agents
power-irish ;;   sum of the power of all Irish agents
]

turtles-own [
  power
  ally-power
  war-effort
  bellicosity
  allies?
]
irish-own [ stability ]



to setup
  clear-all
  setup-agents
  ask turtles [
    set allies? count alliance-neighbors
  ]
  reset-ticks
end

to setup-agents
  set-default-shape irish "crown"
  ask  n-of (num-irish) patches with [ count turtles-here = 0 ] [   ;; an alternative procedure to create turtles. Makes it easier to work with the Voronoi diagram
      sprout-irish 1[
        set color 53
        set stability 1.0
        set power irish-power * stability
        set size ( 1 + 2 * ( power / 100 ) )                       ;; sizes matches the power meter. The stronger the agent, the bigger it is.
        set bellicosity irish-bellicosity
  ]
  ]
  set-default-shape english "chess rook"
  ask  n-of (num-english) patches with [ count turtles-here = 0 ] [
      sprout-english 1[
        set color 13
        set power english-power
        set size ( 1 + 2 * ( power / 100 ) )
        set bellicosity english-bellicosity
    ]
  ]
  ask patches [refresh-territory]
end

to go
  ask wars [ die ]                                               ;; unlike alliance requests, wars are killed at the beginning of a tick, so we can see which ones have formed at each tick
  set power-english  sum [ power ] of english                    ;; set up "power" as a global variable so it can be plotted
  set power-irish sum [ power ] of irish
  if not any? irish [ stop ]                                     ;; if there are no agents of any one breed, stops the simulation
  if not any? english [ stop ]
  ask turtles [
    set allies? count alliance-neighbors
    replenish-power
    offer-alliance
    accept-alliance
    declare-war
    opt-out
    wage-war
    set size ( 1 + 2 * ( power / 100 ) )
    perish
  ]
  ask patches [
  refresh-territory
  ]
  ask alliance-requests [ die ]
  tick
end

;; Environment Procedures

to refresh-territory
  set pcolor [color + 2] of min-one-of turtles [distance myself]       ;; this is the code that generates the Voronoi diagram
end


;; Turtle Procedures

to replenish-power
  set power ( power + 10 )
  if power >= 100 [                                  ;; power needs to be capped, lest it baloons indefinitely
    set power 100
  ]
  if breed = irish and stability? [ set power ( stability * power ) ]

end

to offer-alliance
    if allies? = 0 [
    if any? other turtles with [ allies? = 0 ] [
    ask one-of other turtles with [ allies? = 0] [
    create-alliance-request-from myself]
  ask alliance-requests [ set color yellow ]          ;; alliance-requests are colored yellow for debugging purposes only. Since they are killed the same time unit they are generated, we never get to see them
  ]
    ]
  if allies? > 0 [
    set bellicosity bellicosity - 0.1
    if bellicosity <= 0 [                            ;; bellicosity needs to be capped, lest it drop below 0.0
      set bellicosity 0
    ]
  ]
end

to accept-alliance
  if any? in-alliance-request-neighbors with [ power >= [power] of myself  ] [
    ask out-alliance-neighbors [ die ]                                            ;; agents suspend offers of alliance if they happen to receive a favorable one. This is to ensure each agent gets only one ally.
    if any? alliance-request-neighbors [
    create-alliance-with one-of alliance-request-neighbors
    ]
  ask alliances [
    set color white
  ]
  ]
end

to declare-war
  if warfare = "all-out" [
    if any? other turtles with [ not alliance-neighbor? myself and power <= [ power ] of myself ] [              ;; agents won't wage wars with enemies more powerful than themselves
   if random-float 1.0 < bellicosity [                                                                           ;; the "roll" that determines propensity to declare war
    ask one-of other turtles with [ not alliance-neighbor? myself and power <= [ power ] of myself ]
   [ create-war-with myself]
   ask wars [ set color black]
   ]
    ]
  ]
  if warfare = "irish-english" [
    if any? other turtles with [ not alliance-neighbor? myself and power <= [ power ] of myself and breed !=[ breed ] of myself ] [
    if random-float 1.0 < bellicosity [
      ask one-of other turtles with [ not alliance-neighbor? myself and power <= [ power ] of myself and breed !=[ breed ] of myself ]
    [ create-war-with myself]
     ask wars [ set color black]
   ]
 ]
  ]
end


To opt-out
  if any? alliance-neighbors with [ any? war-neighbors ] [
    if any? alliance-neighbors with [ power < 0.5 * [power] of myself ] [              ;; if an agent gets too weak, its allies will ditch it.
    ask my-alliances [ die ]
  ]
  ]
end

to wage-war
  set ally-power sum [ power ] of alliance-neighbors
  set war-effort power + ally-power
  ask war-neighbors [
    ifelse ( [ war-effort ] of self ) * random-float 1.0 < ( [ war-effort ] of myself )     ;; calculation that determines the outcome of wars
    [ set power ( power - random-float 30 )
      set bellicosity bellicosity + 0.1
      if bellicosity > 1 [ set bellicosity 1 ]
        if breed = irish and stability? [ set stability stability - 0.1 ]                   ;; irish agents lose stability when defeated
    ]
    [ set power ( power - random-float 10 )                                                 ;; loss of power due to attrition and war expenses
      set bellicosity bellicosity + 0.1
      if bellicosity > 1 [ set bellicosity 1 ]
        if breed = irish and stability? [ set stability stability - 0.1 ]
    ]
  ]

end


to perish
    if power <= 0 [ die ]
end


;; Interface Button Procedures


to clear-alliances
  ask alliances [ die ]
end

to provoke-english
  ask english [ set bellicosity bellicosity + 0.1 ]
end

to provoke-irish
  ask irish [ set bellicosity bellicosity + 0.1 ]
end
@#$#@#$#@
GRAPHICS-WINDOW
300
35
858
594
-1
-1
17.742
1
10
1
1
1
0
0
0
1
-15
15
-15
15
1
1
1
ticks
30.0

BUTTON
25
270
88
303
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
35
40
127
73
num-irish
num-irish
1
20
10.0
1
1
NIL
HORIZONTAL

SLIDER
35
75
127
108
num-english
num-english
1
20
10.0
1
1
NIL
HORIZONTAL

SLIDER
155
40
270
73
irish-power
irish-power
1
100
65.0
1
1
NIL
HORIZONTAL

SLIDER
155
75
270
108
english-power
english-power
1
100
100.0
1
1
NIL
HORIZONTAL

SWITCH
30
190
140
223
stability?
stability?
0
1
-1000

BUTTON
95
270
170
303
go once
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
180
270
243
303
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
30
127
149
160
irish-bellicosity
irish-bellicosity
0
1
0.5
0.1
1
NIL
HORIZONTAL

SLIDER
154
127
274
160
english-bellicosity
english-bellicosity
0
1
0.5
0.1
1
NIL
HORIZONTAL

PLOT
875
50
1210
269
Overall power
Time
Power
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"English" 1.0 0 -2674135 true "" "plot power-english"
"Irish" 1.0 0 -10899396 true "" "plot power-irish"

CHOOSER
165
190
275
235
warfare
warfare
"all-out" "irish-english"
0

PLOT
875
300
1210
514
Diplomacy
Time
Diplomatic Ties
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"Alliances" 1.0 0 -11221820 true "" "plot count alliances"
"Wars" 1.0 0 -16777216 true "" "plot count wars"

BUTTON
15
325
133
358
Clear alliances
clear-alliances
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
1240
30
1610
215
English bellicosity
time
Bellicosity
0.0
1.0
0.0
1.0
true
false
"" ""
PENS
"English" 1.0 0 -2674135 true "" "ask english [ \ncreate-temporary-plot-pen (word who)\n  set-plot-pen-color r                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 