breed [qms qm]
breed [confs conf]
breed [rebels rebel]
breed [devs dev]
globals [
  trait-list
  confs-culture
  qms-culture
  rebels-culture
  devs-culture
  ;; from here to the end of the globals list are variables that are needed for analysis of the model
  initial-confs
  initial-devs
  initial-rebels
  initial-qms
  qms-diff
  confs-diff
  rebels-diff
  devs-diff
  conf-qm
  dev-qm
  rebel-dev
  conf-dev
  rebel-qm
  conf-rebel
  c-pop
  qm-pop
  d-pop
  r-pop
  ]
turtles-own [
  my-culture
  partner
  change
  changeable?
  total-partners
  generation]

to setup
  ca
  reset-ticks
  set-default-shape turtles "circle"

  let n 0
  set trait-list [] ;; compile list of traits. this wil be used later for compiling cultures.
  repeat 60 [
    set trait-list lput n trait-list
    set n n + 1
    ]
  ask patches with [pxcor > 0 and pycor > 0][ set pcolor white]
  ask patches with [pxcor <= 0 and pycor > 0][ set pcolor gray]
  ask patches with [pxcor <= 0 and pycor <= 0][ set pcolor pink ]
  ask patches with [pxcor > 0 and pycor <= 0] [set pcolor violet]
  make-turtles
  ask turtles [ set partner nobody ]
end

to go
  tick
  clear-links
interact-step-1
analyze-cultures
switch-breeds
die-and-replace
output-similarities
output-diff

if ((mean [generation] of turtles) >= 2) and ((mean [total-partners] of turtles) >= 500) [stop]


end


to make-turtles  ;;; creates turtles, assigns to breeds, assigns primary traits and secondary traits.
                 ;;; One is hatched, creates the rest, and then dies.
  create-confs 1 [set color orange set size .5
    set confs-culture [ 1 2 3 4 5 16 19 20]
    set initial-confs confs-culture
    hatch 120 [
      set my-culture [confs-culture] of self
      set-culture
      move-to one-of patches with [pcolor = violet]
      set total-partners 0
      set change 0
      ]
    die]

  create-qms 1 [set color green set size .5
    set qms-culture [ 1 2 3 7 10 13 17 18 ]
    set initial-qms qms-culture
    hatch 2 [
      set my-culture [qms-culture] of self
      set-culture
      move-to one-of patches with [pcolor = white]
      set total-partners 0
      set change 0
    ]
    die]


  create-rebels 1 [set color black set size .5
    set rebels-culture [ 4 15 7 8 9 14 17 18 ]
    set initial-rebels rebels-culture
    hatch 8 [
      set my-culture [rebels-culture] of self
      set-culture
      move-to one-of patches with [pcolor = pink]
      set total-partners 0
      set change 0
    ]
    die]

  create-devs 1 [set color red set size .5
    set devs-culture [ 6 8 9 11 12 13 21 22 ]
    set initial-devs devs-culture
    hatch 70 [
      set my-culture [devs-culture] of self
      set-culture
      move-to one-of patches with [pcolor = grey]
      set total-partners 0
      set change 0
    ]
    die]

end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;; these are the procedures for giving the turtles their cultures.


to set-culture
  ifelse (num-traits - length my-culture) > 0 [
    repeat (num-traits - length my-culture) [ pick-new-trait ]] [
    while [length my-culture > num-traits] [set my-culture remove-item random (length my-culture) my-culture]] ;; defensive coding
end

to pick-new-trait ;; fills out secondary traits and ensures no doubles of traits.
 let new-trait random 38 + 22
    ifelse not member? new-trait my-culture [
          set my-culture lput new-trait my-culture][
          pick-new-trait]
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; now we write the code for the turtles to interact


to interact-step-1
 ask turtles [
   let p one-of my-culture
   let potential-partners other turtles with [member? p my-culture] ;; sets agentset to turtles with value p
 ;   show potential-partners
   set partner one-of potential-partners
 ;   show partner
   if (partner != nobody) [
   create-link-with partner [set color 125]
    ; show count link-neighbors
   set total-partners total-partners + count my-links
    ;  show total-partners

     if resistance-level = "low" [low-interact-step-2]
     if resistance-level = "mid" [mid-interact-step-2]
     if resistance-level = "high" [hi-interact-step-2]
   ]
]

end

to low-interact-step-2
if is-dev? self [
   if is-qm? partner and random-float 1 > .95 [ move-traits]
   if is-rebel? partner and random-float 1 > .4 [ move-traits]
   if is-conf? partner and random-float 1 > .9 [ move-traits]
   if is-dev? partner [ move-traits]
 ]
if is-conf? self[
  if is-qm? partner and random-float 1 > .95 [ move-traits]
  if is-rebel? partner and random-float 1 > .9 [ move-traits]
  if is-dev? partner [] ;a conf will never take on properties of a dev
  if is-conf? partner [ move-traits]
]
if is-qm? self [
   if is-conf? partner [] ;; a qm will never take on properties of a dev
   if is-rebel? partner [] ;; a qm will never take on properties of a dev
   if is-dev? partner [] ;; a qm will never take on properties of a dev
   if is-qm? partner [ move-traits]
 ]
 if is-rebel? self [
   if is-qm? partner and random-float 1 > .8 [ move-traits]
   if is-conf? partner [] ;; a rebel will never take on properties of a conf
   if is-dev? partner [] ;; a rebel will never take on properties of a dev
   if is-rebel? partner [ move-traits]
 ]
end

 to mid-interact-step-2
if is-dev? self [
   if is-qm? partner and random-float 1 > .97 [ move-traits]
   if is-rebel? partner and random-float 1 > .6 [ move-traits]
   if is-conf? partner and random-float 1 > .925 [ move-traits]
   if is-dev? partner [ move-traits]
 ]
if is-conf? self[
  if is-qm? partner and random-float 1 > .9625[ move-traits]
  if is-rebel? partner and random-float 1 > .925 [ move-traits]
  if is-dev? partner and random-float 1 > .8 [ move-traits]
  if is-conf? partner [ move-traits]
]
if is-qm? self [
   if is-conf? partner [] ;; a qm will never take on properties of a conf
   if is-rebel? partner [] ;; a qm will never take on properties of a rebel
   if is-dev? partner [] ;; a qm will never take on properties of a dev
   if is-qm? partner [ move-traits]
 ]
 if is-rebel? self [
   if is-qm? partner and random-float 1 > .85 [ move-traits]
   if is-conf? partner [] ;; a rebel will never take on properties of a conf
   if is-dev? partner [] ;; a rebel will never take on properties of a dev
   if is-rebel? partner [ move-traits]
 ]

 end


to hi-interact-step-2
if is-dev? self [
   if is-qm? partner and random-float 1 > .99 [ move-traits]
   if is-rebel? partner and random-float 1 > .8 [ move-traits]
   if is-conf? partner and random-float 1 > .95 [ move-traits]
   if is-dev? partner [ move-traits]
 ]
if is-conf? self[
  if is-qm? partner and random-float 1 > .975 [ move-traits]
  if is-rebel? partner and random-float 1 > .95 [ move-traits]
  if is-dev? partner and random-float 1 > .6 [ move-traits]
  if is-conf? partner [ move-traits]
]
if is-qm? self [
   if is-conf? partner [] ;; a qm will never take on properties of a conf
   if is-rebel? partner [] ;; a qm will never take on properties of a rebel
   if is-dev? partner [] ;; a qm will never take on properties of a dev
   if is-qm? partner [ move-traits]
 ]
 if is-rebel? self [
   if is-qm? partner and random-float 1 > .9 [ move-traits]
   if is-conf? partner [] ;; a rebel will never take on properties of a conf
   if is-dev? partner [] ;; a rebel will never take on properties of a dev
   if is-rebel? partner [ move-traits]
 ]

 end

to move-traits ;; upon finding a partner, the calling agent replaces randomly chosen value with a randomly chosen value from the called agent.
  let n one-of [my-culture] of partner
  set my-culture replace-item (random num-traits) my-culture n
end

to analyze-cultures
  let full-confs-culture (compile-cultures confs confs-culture)
  let full-qms-culture (compile-cultures qms qms-culture)
  let full-rebels-culture (compile-cultures rebels rebels-culture)
  let full-devs-culture (compile-cultures devs devs-culture)

  let n1 (new-culture full-confs-culture)
  let n2 (new-culture full-qms-culture)
  let n3 (new-culture full-rebels-culture)
  let n4 (new-culture full-devs-culture)

  if length n1 >= 8 [set confs-culture n1 ]
  if length n2 >= 8 [set qms-culture n2 ]
  if length n3 >= 8 [set rebels-culture n3]
  if length n4 >= 8 [set devs-culture n4]
end

to-report compile-cultures [input-breed input-culture] ;; this reporter takes the traits from agents of input-breed and compiles them into one list
  set input-culture [] ;; empties out the input culture
  foreach trait-list [ ?1 ->
    ask turtles with [breed = input-breed] [
      if member? ?1 my-culture [set input-culture lput ?1 input-culture]
    ]
  ]
    report input-culture
  end


to-report new-culture [ culture-list ] ;; a reporter. for a breed B, takes as input the union of my-cultures for turtles of B.

  let temp-list [ ] ;; empty list that will report the 6 most frequently occuring values in culture-list
  let copy-list culture-list ;; list that takes culture-list as input

  let n modes copy-list ;;set n to the most frequently occuring value of the copy-list (i.e. the input list)
  if length n > 1 [repeat (length n) - 1 [set n remove-item (random length n) n]] ;; make sure n has only one item
  foreach n [ ?1 -> if member? ?1 copy-list [set copy-list remove ?1 copy-list] ] ;; removes n from the copy-list
  set temp-list n

  repeat 7 [
    set n modes copy-list ;;set the temp-list to the most frequently occuring value of the copy-list (i.e. the input list)
    if length n > 1 [ ;; make sure n has only one item.
      repeat (length n) - 1 [
        set n remove-item (random length n) n   ;;if there are ties for the mode, losers are chosen at random until one is left.
      ]
    ]
    foreach n [ ?1 -> ;; remove the mode from the copy-list
      if member? ?1 copy-list [
        set copy-list remove ?1 copy-list
      ]
    ] ;; add the mode to the temp-list
    foreach n [ ?1 ->
      if not member? ?1 temp-list [
        set temp-list lput ?1 temp-list
      ]
    ]
  ]
  report temp-list

end

to switch-breeds ;; for a turtle to switch breeds, its my-culture should have the 6 core traits of the new breed.
    ask turtles [

    set changeable? true ;; turtles can change breeds at the start of this procedure. once they've gone through the 'make-changes' routine, they can't change until the next time step.

    let p1s 0 ;; these are tickers to keep track of how many items in my-culture are in each BREED-culture
    let p2s 0
    let p3s 0
    let p4s 0
    let short-my-culture remove-duplicates my-culture
                                                      ;; philosophical question: when determining if an agent should belong to a culture, are we interested in matches on types or tokens?
                                                      ;; if you're a type-person, comment the line following these notes and uncomment the one preceding.
                                                      ;; if you're a token-person, comment the line preceding these notes and uncomment the following.
                                                      ;; the results are different depending on which is run.
   ; let short-my-culture my-culture
    foreach short-my-culture [ ?1 ->
      if member? ?1 confs-culture [set p1s p1s + 1]
      if member? ?1 qms-culture [set p2s p2s + 1]
      if member? ?1 rebels-culture [set p3s p3s + 1]
      if member? ?1 devs-culture [ set p4s p4s + 1]
    ]
    if p2s >= 7 and p2s = p3s and changeable? = true [ifelse random 2 = 0 [set breed qms make-changes] [set breed rebels make-changes]] ;; check for any ties with cultures and then make changes at random
    if p2s >= 7 and p2s = p4s and changeable? = true [ifelse random 2 = 0 [set breed qms make-changes] [set breed devs make-changes]]
    if p3s >= 7 and p3s = p4s and changeable? = true [ifelse random 2 = 0 [set breed rebels make-changes] [set breed devs make-changes]]
    if p1s >= 7 and p1s = p2s and changeable? = true [ifelse random 2 = 0 [set breed confs make-changes] [set breed qms make-changes]]
    if p1s >= 7 and p1s = p3s and changeable? = true [ifelse random 2 = 0 [set breed confs make-changes] [set breed rebels make-changes]]
    if p1s >= 7 and p1s = p4s and changeable? = true [ifelse random 2 = 0 [set breed confs make-changes] [set breed devs make-changes]]

    if (p1s >= 7 or p2s >= 7 or p3s >= 7 or p4s >= 7) [ ;; if tickers exceed 8
      if (p3s > p1s and p3s > p2s and p3s > p4s) and changeable? = true [set breed rebels make-changes]
      if (p4s > p1s and p4s > p2s and p4s > p3s) and changeable? = true [set breed devs make-changes]
      if (p1s > p2s and p1s > p3s and p1s > p4s) and changeable? = true [set breed confs make-changes]  ;; then check for which culture best fits the agent
      if (p2s > p1s and p2s > p3s and p2s > p4s) and changeable? = true [set breed qms make-changes]

    ]

  ]


end

to make-changes ;; a little tidying up for the visuals
  if [breed] of self = confs [
    set color orange
    set change change + 1
    move violet
    if any? turtles-here [move violet]
    set changeable? false
  ]
  if [breed] of self = qms [
    set color green
          set change change + 1
          move white
          if any? turtles-here [move white]
          set changeable? false
  ]
  if [breed] of self = devs[
  set color red
          set change change + 1
          move gray
          if any? turtles-here [move grey]
          set changeable? false
]
if [breed] of self = rebels [
  set color black
          set change change + 1
          move pink
          if any? turtles-here [move pink]
          set changeable? false
]

end

to move [clr]
    move-to one-of patches with [pcolor = clr]
end

to output-similarities ;;  checks for similarities among cultures.

  let a sort remove-duplicates (sentence confs-culture qms-culture)
  set conf-qm 2 - (length a / 8)

  let b sort remove-duplicates (sentence devs-culture qms-culture)
  set dev-qm 2 - (length b / 8)

  let c sort remove-duplicates (sentence confs-culture devs-culture)
  set conf-dev 2 - (length c / 8)

  let d sort remove-duplicates (sentence rebels-culture devs-culture)
  set rebel-dev 2 - (length d / 8)

  let f remove-duplicates (sentence confs-culture rebels-culture)
  set conf-rebel 2 - (length f / 8)

  let g remove-duplicates (sentence rebels-culture qms-culture)
  set rebel-qm 2 - (length g / 8)

end

to output-diff ;; checks for difference from the starting point
  set-current-plot "difference from initial culture"

  let iqms remove-duplicates (sentence initial-qms qms-culture)
  ;output-type "initial-current qms difference: "
  set qms-diff   (1 - (2 - (length iqms / 8)))
  set-current-plot-pen "qmd"
  set-plot-pen-color green
  plot qms-diff

  let id remove-duplicates (sentence initial-devs devs-culture)
  ;output-type "initial-current confs difference: "
  set devs-diff (1 - (2 - (length id / 8)))
  set-current-plot-pen "dd"
  set-plot-pen-color red
  plot devs-diff

  let ir remove-duplicates (sentence initial-rebels rebels-culture)
  ;output-type "initial-current confs difference: "
  set rebels-diff (1 - (2 - (length ir / 8)))
  set-current-plot-pen "rd"
  set-plot-pen-color black
  plot rebels-diff

   let ic remove-duplicates (sentence initial-confs confs-culture)
  ;output-type "initial-current confs difference: "
  set confs-diff (1 - (2 - (length ic / 8)))
  set-current-plot-pen "cd"
  set-plot-pen-color orange
  plot confs-diff

  set-current-plot "populations"

  set-current-plot-pen "c"
  set-plot-pen-color orange
  set c-pop (count confs / count turtles)
  plot c-pop

  set-current-plot-pen "qm"
  set-plot-pen-color green
  set qm-pop (count qms / count turtles)
  plot qm-pop

  set-current-plot-pen "d"
  set-plot-pen-color red
  set d-pop (count devs / count turtles)
  plot d-pop

  set-current-plot-pen "r"
  set-plot-pen-color black
  set r-pop (count rebels / count turtles)
  plot r-pop

end

to die-and-replace
  ask turtles [
    if total-partners >= 1000 [
      hatch 1 [
        set breed [breed] of myself
        set color [color] of myself
        set xcor [xcor] of myself
        set ycor [ycor] of myself
        set change 0
        set total-partners 0
        if breed = confs [
          set my-culture n-of random 9 confs-culture
          set-culture
          set generation generation + 1
        ]
        if breed = qms [
          set my-culture n-of random 9 qms-culture
          set-culture
          set generation generation + 1
        ]
        if breed = devs [
          set my-culture n-of random 9 devs-culture
          set-culture
          set generation generation + 1
        ]
        if breed = rebels [
          set my-culture n-of random 9 rebels-culture
          set-culture
          set generation generation + 1
        ]
      ]
      die
    ]
  ]
end

@#$#@#$#@
GRAPHICS-WINDOW
14
87
378
452
-1
-1
10.8
1
10
1
1
1
0
1
1
1
-16
16
-16
16
0
0
1
ticks
30.0

BUTTON
17
10
80
43
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
97
10
160
43
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
16
52
93
85
go-once
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
488
10
1644
377
populations
NIL
NIL
0.0
10.0
0.0
1.0
true
false
"" ""
PENS
"c" 1.0 0 -955883 true "" ""
"qm" 1.0 0 -10899396 true "" ""
"d" 1.0 0 -2674135 true "" ""
"r" 1.0 0 -16777216 true "" ""

MONITOR
212
533
310
578
confs
count confs
17
1
11

MONITOR
212
481
302
526
qms
count qms
17
1
11

MONITOR
103
481
198
526
devs
count devs
17
1
11

MONITOR
104
531
206
576
rebels
count rebels
17
1
11

CHOOSER
222
10
332
55
Resistance-level
Resistance-level
"low" "mid" "high"
0

SLIDER
221
55
332
88
num-traits
num-traits
1
25
13.0
1
1
NIL
HORIZONTAL

PLOT
488
381
1644
810
difference from initial culture
NIL
NIL
0.0
10.0
0.0
1.0
true
false
"" ""
PENS
"cd" 1.0 0 -7500403 true "" ""
"qmd" 1.0 0 -2674135 true "" ""
"dd" 1.0 0 -955883 true "" ""
"rd" 1.0 0 -6459832 true "" ""

@#$#@#$#@
## WHAT IS IT?

(a general understanding of what the model is trying to show or explain)

## HOW IT WORKS

(what rules the agents use to create the overall behavior of the model)

## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)

## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.0.1
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="low traits low rtc" repetitions="25" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <metric>qms-diff</metric>
    <metric>confs-diff</metric>
    <metric>rebels-diff</metric>
    <metric>devs-diff</metric>
    <metric>conf-qm</metric>
    <metric>dev-qm</metric>
    <metric>rebel-dev</metric>
    <metric>conf-dev</metric>
    <metric>rebel-qm</metric>
    <metric>conf-rebel</metric>
    <metric>c-pop</metric>
    <metric>qm-pop</metric>
    <metric>d-pop</metric>
    <metric>r-pop</metric>
    <enumeratedValueSet variable="num-traits">
      <value value="13"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Resistance-level">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="low traits &amp; mid rtc" repetitions="25" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <metric>qms-diff</metric>
    <metric>confs-diff</metric>
    <metric>rebels-diff</metric>
    <metric>devs-diff</metric>
    <metric>conf-qm</metric>
    <metric>dev-qm</metric>
    <metric>rebel-dev</metric>
    <metric>conf-dev</metric>
    <metric>rebel-qm</metric>
    <metric>conf-rebel</metric>
    <metric>c-pop</metric>
    <metric>qm-pop</metric>
    <metric>d-pop</metric>
    <metric>r-pop</metric>
    <enumeratedValueSet variable="Resistance-level">
      <value value="&quot;mid&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-traits">
      <value value="13"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="low traits &amp; high rtc" repetitions="25" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <metric>qms-diff</metric>
    <metric>confs-diff</metric>
    <metric>rebels-diff</metric>
    <metric>devs-diff</metric>
    <metric>conf-qm</metric>
    <metric>dev-qm</metric>
    <metric>rebel-dev</metric>
    <metric>conf-dev</metric>
    <metric>rebel-qm</metric>
    <metric>conf-rebel</metric>
    <metric>c-pop</metric>
    <metric>qm-pop</metric>
    <metric>d-pop</metric>
    <metric>r-pop</metric>
    <enumeratedValueSet variable="Resistance-level">
      <value value="&quot;high&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-traits">
      <value value="13"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="mid traits &amp; low rtc" repetitions="25" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <metric>qms-diff</metric>
    <metric>confs-diff</metric>
    <metric>rebels-diff</metric>
    <metric>devs-diff</metric>
    <metric>conf-qm</metric>
    <metric>dev-qm</metric>
    <metric>rebel-dev</metric>
    <metric>conf-dev</metric>
    <metric>rebel-qm</metric>
    <metric>conf-rebel</metric>
    <metric>c-pop</metric>
    <metric>qm-pop</metric>
    <metric>d-pop</metric>
    <metric>r-pop</metric>
    <enumeratedValueSet variable="Resistance-level">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-traits">
      <value value="15"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="mid traits &amp; mid rtc" repetitions="25" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <metric>qms-diff</metric>
    <metric>confs-diff</metric>
    <metric>rebels-diff</metric>
    <metric>devs-diff</metric>
    <metric>conf-qm</metric>
    <metric>dev-qm</metric>
    <metric>rebel-dev</metric>
    <metric>conf-dev</metric>
    <metric>rebel-qm</metric>
    <metric>conf-rebel</metric>
    <metric>c-pop</metric>
    <metric>qm-pop</metric>
    <metric>d-pop</metric>
    <metric>r-pop</metric>
    <enumeratedValueSet variable="Resistance-level">
      <value value="&quot;mid&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-traits">
      <value value="15"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="mid traits &amp; high rtc" repetitions="25" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <metric>qms-diff</metric>
    <metric>confs-diff</metric>
    <metric>rebels-diff</metric>
    <metric>devs-diff</metric>
    <metric>conf-qm</metric>
    <metric>dev-qm</metric>
    <metric>rebel-dev</metric>
    <metric>conf-dev</metric>
    <metric>rebel-qm</metric>
    <metric>conf-rebel</metric>
    <metric>c-pop</metric>
    <metric>qm-pop</metric>
    <metric>d-pop</metric>
    <metric>r-pop</metric>
    <enumeratedValueSet variable="Resistance-level">
      <value value="&quot;high&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-traits">
      <value value="15"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="high traits &amp; low rtc" repetitions="25" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <metric>qms-diff</metric>
    <metric>confs-diff</metric>
    <metric>rebels-diff</metric>
    <metric>devs-diff</metric>
    <metric>conf-qm</metric>
    <metric>dev-qm</metric>
    <metric>rebel-dev</metric>
    <metric>conf-dev</metric>
    <metric>rebel-qm</metric>
    <metric>conf-rebel</metric>
    <metric>c-pop</metric>
    <metric>qm-pop</metric>
    <metric>d-pop</metric>
    <metric>r-pop</metric>
    <enumeratedValueSet variable="Resistance-level">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-traits">
      <value value="18"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="high traits &amp; mid rtc" repetitions="25" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <metric>qms-diff</metric>
    <metric>confs-diff</metric>
    <metric>rebels-diff</metric>
    <metric>devs-diff</metric>
    <metric>conf-qm</metric>
    <metric>dev-qm</metric>
    <metric>rebel-dev</metric>
    <metric>conf-dev</metric>
    <metric>rebel-qm</metric>
    <metric>conf-rebel</metric>
    <metric>c-pop</metric>
    <metric>qm-pop</metric>
    <metric>d-pop</metric>
    <metric>r-pop</metric>
    <enumeratedValueSet variable="Resistance-level">
      <value value="&quot;mid&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-traits">
      <value value="18"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="high traits &amp; high rtc" repetitions="25" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <metric>qms-diff</metric>
    <metric>confs-diff</metric>
    <metric>rebels-diff</metric>
    <metric>devs-diff</metric>
    <metric>conf-qm</metric>
    <metric>dev-qm</metric>
    <metric>rebel-dev</metric>
    <metric>conf-dev</metric>
    <metric>rebel-qm</metric>
    <metric>conf-rebel</metric>
    <metric>c-pop</metric>
    <metric>qm-pop</metric>
    <metric>d-pop</metric>
    <metric>r-pop</metric>
    <enumeratedValueSet variable="Resistance-level">
      <value value="&quot;high&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-traits">
      <value value="18"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
