breed [ squares square ]
breed [ circles circle ]


globals [
  circles-change
  squares-change ;; maybe average % of change of squares and circles?
  circles-encounters
  squares-encounters
]

turtles-own [ 
    percentage-change ;; percentage of color change - 0-100% possible
    positive-encounters ;; memory of positive-encounters - coded 1
    negative-encounters ;; memory of negative-encounters - coded 2
    total-contacts ;; cumulative memory of encounters with others
]


to setup
  clear-all
  setup-turtles
  reset-ticks
end



to setup-turtles
  ;;set pen-mode down - maybe try to trace their paths?
  set-default-shape squares "sq-face"
  set-default-shape circles "face happy"
  create-squares square-population
  [set color 15
     set positive-encounters 0
     set negative-encounters 0
     set total-contacts 0 ]
  create-circles circle-population
  [set color 115
    set positive-encounters 0
    set negative-encounters 0 
    set total-contacts 0 ]
  ask turtles [setxy random-xcor random-ycor]
end 
  
to go
  ;;if all? turtles [nested?] [ stop ] 
  ask squares [
    squares-go 
    squares-contact
    ]
  ask circles [
    circles-go 
    circles-contact
    ]
  tick
end 

to squares-go
  let similar other squares in-radius sq-xeno-vision
  let others circles in-radius sq-xeno-vision
  if sq-intergroup-pref = "self" AND any? similar
  [ face one-of similar]
  
  if sq-intergroup-pref = "random"
  [ ;;let neighbor similar OR others
    face one-of neighbors ]
  
  if sq-intergroup-pref = "other" AND any? others
  [ face one-of others ]
  fd sq-wanderlust
end

to circles-go
  let similar other circles in-radius ci-xeno-vision
  let others squares in-radius ci-xeno-vision
  if ci-intergroup-pref = "self" AND any? similar
  [ face one-of similar ]
  
  if ci-intergroup-pref = "random"
  [ ;;let neighbor similar OR others
    face one-of neighbors ]

  if ci-intergroup-pref = "other" AND any? others
  [ face one-of others ] 
  fd ci-wanderlust
end


to squares-contact
  let reaction random 100
  let others circles in-radius 1
  if any? others AND reaction >= likely-negative
  [set positive-encounters positive-encounters + 1 ]
  if any? others AND reaction < likely-negative
  [set negative-encounters negative-encounters + 1 ]
  let ME self
  let skin [color] of ME
  if positive-encounters >= sq-change-resistance AND skin < 65
  [ set color skin + 10 set positive-encounters 0 encounter ]
  if negative-encounters >= sq-change-resistance AND skin > 15 AND skin <= 65
  [ set color skin - 10 set negative-encounters 0 encounter ] 
  if skin = 65 AND positive-encounters < sq-change-resistance [ set positive-encounters positive-encounters + 1 encounter ] 
  if skin = 65 AND positive-encounters >= sq-change-resistance [ set positive-encounters 0 ]
  if skin = 65 AND negative-encounters < sq-change-resistance [ set negative-encounters negative-encounters + 1 encounter ] 
  if skin = 65 AND negative-encounters >= sq-change-resistance [ set negative-encounters 0 ]
  update-squares
  update-globals
end
  
to circles-contact
  let reaction random 100
  let others squares in-radius 1
  if any? others AND reaction >= likely-negative
  [set positive-encounters positive-encounters + 1 ]
  if any? others AND reaction < likely-negative
  [set negative-encounters negative-encounters + 1 ]
  let ME self
  let skin [color] of ME
  if positive-encounters >= ci-change-resistance AND skin > 65
  [ set color skin - 10 set positive-encounters 0 encounter ]
  if negative-encounters >= ci-change-resistance AND skin >= 65 AND skin < 115
  [ set color skin + 10 set negative-encounters 0 encounter ]
  if skin = 65 AND positive-encounters < ci-change-resistance [ set positive-encounters positive-encounters + 1 encounter ] 
  if skin = 65 AND positive-encounters >= ci-change-resistance [ set positive-encounters 0 ]
  if skin = 65 AND negative-encounters < ci-change-resistance [ set negative-encounters negative-encounters + 1 encounter ] 
  if skin = 65 AND negative-encounters >= ci-change-resistance [ set negative-encounters 0 ]
  update-circles
  update-globals
end

to encounter
  set total-contacts total-contacts + 1
end

to update-circles
  ask circles [
  let original-color 115 
  let newcolor color
  set percentage-change abs (newcolor - original-color)
  ]
end

to update-squares
  ask squares [
  let original-color 15 
  let newcolor color
  set percentage-change abs (newcolor - original-color)
  ]
end

to update-globals
  set circles-change abs mean [percentage-change] of circles * 2 ;; sum of each circles color-change / number of circles
  set squares-change abs mean [percentage-change] of squares * 2;;
  set circles-encounters mean [total-contacts] of circles
  set squares-encounters mean [total-contacts] of squares
end
@#$#@#$#@
GRAPHICS-WINDOW
221
61
660
521
16
16
13.0
1
10
1
1
1
0
1
1
1
-16
16
-16
16
1
1
1
ticks
30.0

SLIDER
43
62
215
95
square-population
square-population
25
300
300
25
1
NIL
HORIZONTAL

BUTTON
526
22
592
55
NIL
Setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
666
62
838
95
circle-population
circle-population
25
300
25
25
1
NIL
HORIZONTAL

SLIDER
32
232
214
265
sq-change-resistance
sq-change-resistance
1
10
10
1
1
NIL
HORIZONTAL

SLIDER
666
230
852
263
ci-change-resistance
ci-change-resistance
1
10
10
1
1
NIL
HORIZONTAL

CHOOSER
68
141
214
186
sq-intergroup-pref
sq-intergroup-pref
"self" "random" "other"
1

CHOOSER
666
143
807
188
ci-intergroup-pref
ci-intergroup-pref
"self" "random" "other"
1

SLIDER
43
102
215
135
sq-wanderlust
sq-wanderlust
1
5
1
1
1
NIL
HORIZONTAL

SLIDER
666
103
838
136
ci-wanderlust
ci-wanderlust
1
5
5
1
1
NIL
HORIZONTAL

BUTTON
596
22
659
55
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
671
370
871
520
percentage change
time
change
0.0
10.0
0.0
100.0
true
true
"" ""
PENS
"circles" 1.0 0 -8630108 true "" "plot circles-change"
"squares" 1.0 0 -2674135 true "" "plot squares-change"

BUTTON
915
336
1055
369
trace square path
ask squares [pd]
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
916
374
1051
407
trace circle path
ask circles [pd]
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
42
192
214
225
sq-xeno-vision
sq-xeno-vision
1
5
1
1
1
NIL
HORIZONTAL

SLIDER
666
193
838
226
ci-xeno-vision
ci-xeno-vision
1
5
5
1
1
NIL
HORIZONTAL

PLOT
14
366
214
516
mean # encounters
circles
squares
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"squares" 1.0 0 -2674135 true "" "plot squares-encounters"
"circles" 1.0 0 -8630108 true "" "plot circles-encounters"

PLOT
916
177
1116
327
total contacts
NIL
NIL
0.0
50.0
0.0
50.0
true
true
"" ""
PENS
"squares" 1.0 1 -2674135 true "" "histogram [total-contacts] of squares"
"circles" 1.0 1 -8630108 true "" "histogram [total-contacts] of circles"

MONITOR
914
64
1034
109
circle encounters
[total-contacts] of circles
17
1
11

SLIDER
222
21
394
54
likely-negative
likely-negative
0
100
50
1
1
NIL
HORIZONTAL

TEXTBOX
400
30
550
52
how likely is the\\nencounter to be negative?
9
0.0
1

TEXTBOX
106
40
256
58
squares start red
11
15.0
1

TEXTBOX
670
40
820
58
circles start violet
11
115.0
1

MONITOR
1058
65
1115
110
total
sum [total-contacts] of circles
17
1
11

MONITOR
1059
116
1116
161
total
sum [total-contacts] of squares
17
1
11

MONITOR
914
115
1043
160
square encounters
[total-contacts] of squares
17
1
11

TEXTBOX
775
41
925
59
maximum change green
9
65.0
1

MONITOR
916
415
1029
460
circles change %
circles-change
1
1
11

MONITOR
916
465
1039
510
squares change %
squares-change
1
1
11

@#$#@#$#@
## WHAT IS IT?

This project is a model of Contact Theory/Hypothesis (http://en.wikipedia.org/wiki/Contact_hypothesis) which posits that contact is the best way to reduce prejudice and conflict between minority and majority group members is through interpersonal contact. According to contact theory, even indirect contact, contact through media or even imagined positive contact can help reduce prejudice and stereotyping ! This model shows how different aspects of open-mindedness and personal preference also play into improved intergroup relations. 

The model simulates the behaviour of two types of groups of people in a not too far off world.  Each of these groups, the violet and red people, are made up of happy individuals that get along with members of their own group.  However, each group exhibits different preferences with respect to their willingness to travel (wanderlust), their preference for who they hang out with (homophily), and how much they dislike or fear others in their world (xenophobia).  Because of their strong preferences, each group also shows different degrees of willingness to change their minds unless they have real world encounters to base their opinions on.  That is, each person has a set of perconceived ideas about "others" in their world.  Curiosity and fear around ideas of travel and differences influence how people experience their world, their attitudes, and their social networks.


## HOW IT WORKS

SETUP: 
Create 2 populations (squares and circles) based on POPULATION sliders.  The populations appears in random locations.
Squares start out red.
Circles start out violet.

GO:
Check out surroundings based on XENO-VISION
Turn towards preferred peer based on INTERGROUP PREFERENCE (Self, Other or Random)
Move based on WANDERLUST
Have an ENCOUNTER...

MAKE CONTACT: 
Look around at all neighbors
Check out if there are any OTHERS
Remember if encounter is POSITIVE or NEGATIVE
Change color ONE HUE from original towards GREEN if memory of POSITIVE encounters = CHANGE RESISTANCE
Change color ONE HUE back towards original if memory of NEGATIVE encounters = CHANGE RESISTANCE
Remember # of total encounters with OTHERS

## HOW TO USE IT

Each group has a couple of variables that will affect how it explores and interacts in the world:

POPULATION: Number of agents in that group between 25 - 300

WANDERLUST: How much they like to travel and explore the terrain

INTERGROUP PREF (preference): Who they like to hang with... folks like themselves (homophily), different folks (xenophilia) or whoever (random).

XENO-VISION: Radius of how far agents can see. Affects how they make decisions based on their intergroup preference to meet or avoid others.

CHANGE RESISTANCE: How many encounters they will need to change their attitude about the other group, between 1-10. 

Using the LIKELY-NEGATIVE slider on top, you can set how likely the encounter between members of the two groups is to be negative, from 1-100. 

## THINGS TO NOTICE

Check out how much each group is changing on the monitors and on the screen with its colors. When agents are green, they have pretty liberal / positive views of the other group. 
 
Check out how many encounters each group has had and how that corresponds to its level of attitudinal change. 

## THINGS TO TRY

The DEFAULT setting would probably be 50% negative likely encounter, both groups set to random preference, medium wanderlust, xeno-vision and change resistance. Try that with equal populations.

Try setting one group to MAX (300) population and another to MINIMUM (25). What would you need to do to have the majority change its views about the minority group?

Try setting the likelihood of NEGATIVE ENCOUNTER to something really high - 90%. This could simulate the negative representations in the media! (FACT: Only 1% of stories about youth are about good deeds.) 

## EXTENDING THE MODEL

According to CONTACT THEORY HYPOTHESIS, positive intergroup contact results under 4 conditions: 

- Equal Status, both groups taken into an equal status relationship,
- Common Goals, both groups work on a problem/task and share this as a common goal, sometimes called a superordinate goal,
- Intergroup Cooperation, both groups must work together for their common goals without competition,
- Support of authorities, law or customs, some authority that both groups acknowledge and define social norms that support the contact and interactions between the groups and members.

How can these be coded in?

How can we add the impacts of media representation more intentionally? 

How can we represent the way the groups see each other?

What if the groups started with a geographic (patch) preference?

What if the two groups had some fixed identity features?

Make the two groups have collective memory that they transfer to agents like themselves?

Make the agents hang out with people who are like them but also THINK like them (color). 
If groups have collective memory, what would it take to change perceptions of a group of a long history of negative contacts? 

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

Segregation
Mimicry

## CREDITS AND REFERENCES
T.F.  Pettigrew and L.R. Tropp (2006) A meta-analytic test of intergroup contact theory.
Journal of Personality and Social Psychology, Vol 90(5), May 2006, 751-783.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

sq-face
false
0
Rectangle -7500403 true true 30 30 270 270
Circle -7500403 true true 30 60 90
Circle -16777216 true false 41 71 67
Circle -16777216 true false 191 71 67
Polygon -16777216 true false 60 180 105 210 195 210 225 180 240 195 195 240 105 240 45 195

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0.3
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
