breed [worker a-worker]
breed [thief a-cowboy]
breed [police a-police]
turtles-own
[
  money
  user-id
  step-size
  user-control?
]
patches-own[job-salary]
globals[tax]


to setup
  clear-patches
  clear-drawing
  clear-output
  
  ca
  set tax 0
  ask patches
  [                                                   ;;patches represent job, the salary of jobs obey maxwell-Boltzmann velocity distribution
    ifelse(random-float 100.00 < job-ratio)
    [
      let m 2.18e-25
      let k 1.38e-23
      let cons1  m / (2 * pi * k * fair-factor)
      set cons1 cons1 * cons1 * cons1
      set cons1 cons1 * 4 * pi
      let cons2 -1 * m / (2 * k * fair-factor * 100)
      let x random-float 1500.00
      let fv cons1 * x * x * exp(cons2 * x * x)
      set fv  fv * 1e6                               ;;magnify the result to reasonable range
      if(fair-factor > 1)
        [
          set fv fv * fair-factor                      ;;more fair society has lower collective wealth in Boltzmann, so here needs to add reward to fair society
        ]
      set job-salary ceiling fv      
    ]
    [
      set pcolor black                 ;;patch color initialized black 
    ]
  ]
  visualize-job-salary
  create-worker number-of-worker
  [
    set size 2;
    set money 100
    set shape "person"
    set color  blue                                   ;;worker colored blue
    setxy random-xcor random-ycor                     ;;random init position
    set user-control? false
  ]
  create-thief number-of-thief
  [
    set size 2;
    set money 100
    set shape "person"
    set color  red                                    ;;Thief colored red
    setxy random-xcor random-ycor                     ;;random init position
    set user-control? false
  ]
  create-police number-of-police
  [
    set size 2;
    set money 100
    set shape "person"
    set color  brown                                  ;;Police colored brown
    setxy random-xcor random-ycor                     ;;random init position
    set user-control? false
  ]
  reset-ticks
end

to go
  show-money                                          ;;visualize each people's money
  visualize-job-salary                                ;;color patch to visualize salary
  listen-clients                                      ;;hubnet function, listen to user operation
  every 0.1
  [ 
    ask turtles
    [spend-living-expense]                            ;;everyone needs to spend basic living expense
    ask worker
    [ 
      set money money + job-salary
      pay-tax
      if user-control? = false                        ;;aotumatically action doesn not happen if user control the turtle, they same hold for other turtles
      [
        search-job
        worker-change-career
      ]
    ]
    pay-police                                        ;;pay police based on how many tax is collected
    ask police
    [
      punish-thief                                    ;;police in charge of punish thief 
      if user-control? = false
      [
        search                                        ;;walk around 
        police-change-career
      ]
    ]
    ask thief
    [
      grab-money
      if user-control? = false
      [
        search
        thief-change-career
        if(thief-escape-mode?)                      ;;thief will escape when police near by(in a certain range)
        [escape]
      ]
    ]
    catastrophe                                     ;;check whether catastrophe mode is on, and if so do introduce it.
    tick
  ]
  if ticks > 150
  [
    if count turtles = 0
    [stop]
  ]
end

;;;;;;;;;turtle functions;;;;;;;;;;;;;;;;;;;;;
;;turtle spend basic living expense if not die
to spend-living-expense
  check-die                                         
  set money money - living-expense                  ;;;;updete the money left
end

;;if any person(turtle) has 0 or less money, it will die 
to check-die                                       
  if(money <= 0)
  [die]
end

;;choose a random direction and go
to search
  rt random 90
  lt random 90
  fd 0.5
end

;;;;;;;;;;worker functions;;;;;;;;;;;;;;;;;;;;;
to search-job                                       ;;worker isn't allowed to take same job
  search
  while[any? other worker-here]                     ;;so if there is some other worker here, keep searching
  [search]
end

to pay-tax
  let a-tax (job-salary * tax-rate)                 ;;calculate tax
  set money (money - a-tax)                         ;;take this money from worker
  set tax tax + a-tax                               ;;add this money to "government collective"
end
;;this function follows the rules in info tab
to worker-change-career
  if (random-float 100.00 < career-change-tendency)
  [
    ifelse job-salary * (1 - tax-rate) < living-expense
    [
      set breed thief
      set color red
      set shape "person"
    ]
    [
      ifelse(random-float 100.00 >= 30)
      [ search-job]
      [
        let worker-expectation (ifelse-value (0 = count worker)  [0] [mean[money] of worker])   ;;calculate average wealth of worker and thief
        let thief-expectation  (ifelse-value (0 = count thief)  [0] [mean[money] of thief])
        ifelse (job-salary * (1 - tax-rate) < police-pay or worker-expectation < thief-expectation )  ;;trigure the condition of changing career
        [
          ifelse((job-salary * (1 - tax-rate)) < police-pay)                                          ;;choose which to become
          [
            set breed police
            set color brown
            set shape "person"
          ]
          [
            set breed thief
            set color red
            set shape "person"
          ]
        ]
        [search-job]
      ]
    ]
    
  ]
end


;;;;;;;;;;;;;;;police functions;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;punish half of thief's money if there is any thief at the same patch with the police
to punish-thief                                          
  let money-from 0
  if any? thief
  [  
    ask one-of thief
    [
      set money-from money / 2                            ;;record how many money can punish
      set money money / 2
    ]
    set money money + money-from                        
  ]
end

;;this function follows the rules in info tab
to police-change-career
  if (random-float 100.00 < career-change-tendency)
  [
    ifelse(job-salary * (1 - tax-rate) > (floor tax / count police) )
    [
      set breed worker
      set color blue
      set shape "person"
    ]
    [
      let worker-expectation (ifelse-value (0 = count worker)  [0] [mean[money] of worker])
      let thief-expectation  (ifelse-value (0 = count thief)  [0] [mean[money] of thief])
      if(money < worker-expectation or money < thief-expectation)
      [
        ifelse(thief-expectation > worker-expectation)
        [
          set breed thief
          set color red
          set shape "person"
        ]
        [
          set breed worker
          set color blue
          set shape "person"
        ]
      ]
    ]
  ]
end

;;;;;;;;;;;;;;;;;;;;;;;;;thief functions;;;;;;;;;;;;;;;;;;;;;
;;this function follows the rules in info tab
to thief-change-career
  if (random-float 100.00 < career-change-tendency)
  [
    let worker-expectation (ifelse-value (0 = count worker)  [0] [mean[money] of worker])
    let police-expectation (ifelse-value (0 = count police)  [0] [mean[money] of police])
    if(money < worker-expectation or money < police-expectation)
    [
      ifelse worker-expectation >= police-expectation
      [
        set breed worker
        set color blue
        set shape "person"
      ]
      [
        set breed police
        set color brown
        set shape "person"
      ]
    ]
  ]
end
;;try to grab money from worker
to grab-money
  let money-from 0
  if any? worker-here 
  [                                                         ;;if there any worker nearby, then steal money
    ask one-of worker-here
    [
      set money-from  money / 2                             ;;get worker's money info(how much they have
      set money  money / 2
    ]
    set money money + money-from                            ;;successfully steal money, add this money to thief money
  ]
end
;;try to escape from police
to escape
  let object one-of police in-radius thief-vision           ;I simply use in-radius rather than in-cone here because this is not a main parameter, so user do not need to bother set two parameters         
  if object != nobody                                                   
  [
    face object                                                              
    rt 180                                     
    fd 2
  ]  
end


;;system functions
;;use the collective tax to pay for police
to pay-police
  ifelse (tax >= police-pay * (count police))                           ;;if the money is enough to pay all polices
  [
    ask police
    [
      set money money + police-pay                                      ;;give police their payment
    ]
    set tax tax - police-pay * (count police)                           ;;reduce remaining tax
  ]
  [
    ask n-of  (floor tax / police-pay)  police                          ;;if the money is only enough to pay some police, randomly choose whom to pay
    [
      set money money + police-pay
    ]
    set tax tax -  (floor tax / police-pay)  * police-pay               ;;reduce remaining tax
  ]
end
;;whether to show money
to show-money
  ask turtles[
    ifelse show-money?
    [ set label floor money]
    [ set label ""]
  ]
end
;;whether to show job salary, use scale of color to vidualize
to visualize-job-salary
  ask patches with [job-salary > 0]
  [
    ifelse(visualize-job-salary?)
    [ set pcolor scale-color green job-salary 0 50]
    [ set pcolor black]
  ]
end
;;;;;introduce catastrophe to society
to catastrophe
  if catastrophe-mode?
  [
    if (random-float 100.00 < catastrophe-probability)              ;;if catastrophe happens
    [
      let x random-xcor
      let y random-ycor
      let r random-float 2                                          ;;randomly choose a circle
      ask patches with[pxcor < x + r and pxcor > x - r and pycor < y + r and pycor > y - r]      ;;destory jobs within this circle
      [
        set job-salary 0
        ifelse(visualize-job-salary?)
        [set pcolor yellow]                                           ;;use yellow to vidualize catastrophe
        [set pcolor black]
      ]
      ask turtles with[xcor < x + r and xcor > x - r and ycor < y + r and ycor > y - r]          ;;and kill people within this circle
      [die]
    ]
    if (random-float 100.00 < rebuild-probability)                   ;;society has chance to rebuid
    [
      ask one-of patches with[job-salary <= 0]                       ;;by creating some new jobs, and the salary also obey Boltmann distribution
      [
        let m 2.18e-25
        let k 1.38e-23
        let cons1  m / (2 * pi * k * fair-factor)
        set cons1 cons1 * cons1 * cons1
        set cons1 cons1 * 4 * pi
        let cons2 -1 * m / (2 * k * fair-factor * 100)
        let x random-float 1500.00
        let fv cons1 * x * x * exp(cons2 * x * x)
        set fv ceiling (fv * 1e6)
        set job-salary fv
        ifelse(visualize-job-salary?)
        [set pcolor scale-color green fv 0 50]
        [set pcolor black]
      ]
    ]
  ]
end


;;
;; HubNet Procedures
;;


;; the STARTUP procedure runs only once at the beginning of the model
;; at this point you must initialize the system.
to startup
  hubnet-reset
end

to listen-clients
  ;; as long as there are more messages from the clients
  ;; keep processing them.
  while [ hubnet-message-waiting? ]
  [
    ;; get the first message in the queue
    hubnet-fetch-message
    ifelse hubnet-enter-message? ;; when clients enter we get a special message
    [ create-new-student ]
    [
      ifelse hubnet-exit-message? ;; when clients exit we get a special message
      [ remove-student ]
      [ ask turtles with [user-id = hubnet-message-source]
        [ execute-command hubnet-message-tag ] ;; otherwise the message means that the user has
      ]                                        ;; done something in the interface hubnet-message-tag
                                               ;; is the name of the widget that was changed
    ]
  ]
end

;; when a new user logs in create a student turtle
;; this turtle will store any state on the client
;; values of sliders, etc.
to create-new-student
  create-turtles 1
  [
    ;; store the message-source in user-id now
    ;; so when you get messages from this client
    ;; later you will know which turtle it affects
    set user-control? true
    set user-id hubnet-message-source
    set money 100
    set step-size 1
    set breed worker
    set size 2
    set shape "person"
    set color blue
    set xcor random-xcor
    set ycor random-ycor
    ;; update the clients with any information you have set
    send-info-to-clients
  ]
end

to remove-student
  ask turtles with [user-id = hubnet-message-source]
  [ die ]
end

to execute-command [command]
  if command = "step-size"
  [
    set step-size hubnet-message
    stop
  ]
  if command = "up"
  [ execute-move 0 stop ]
  if command = "down"
  [ execute-move 180 stop ]
  if command = "right"
  [ execute-move 90 stop ]
  if command = "left"
  [ execute-move 270 stop ]
  if command = "become-police"
  [ 
    set breed police
    set shape "person"
    set color brown 
  ]
  if command = "become-thief"
  [ 
    set breed thief
    set shape "person"
    set color red
  ]
  if command = "become-worker"
  [ 
    set breed worker
    set shape "person"
    set color blue
  ]
end

;; whenever something in world changes that should be displayed in
;; a monitor on the client send the information back to the client
to send-info-to-clients ;; turtle procedure
  hubnet-send user-id "salary" job-salary
  hubnet-send user-id "tax-rate" tax-rate
  hubnet-send user-id "police-pay" police-pay
  hubnet-send user-id "worker-wealth" ceiling sum [money] of worker
  hubnet-send user-id "thief-wealth"  ceiling sum [money] of thief
  hubnet-send user-id "police-wealth" ceiling sum [money] of police
  if breed = police
  [hubnet-send user-id "career" "police"]
  if breed = worker
  [hubnet-send user-id "career" "worker"]
  if breed = thief
  [hubnet-send user-id "career" "thief"]
end

to execute-move [new-heading]
  set heading new-heading
  fd step-size
  send-info-to-clients
end


;;;;;;;;;;;;show output functions
to-report total-money-of-worker                    ;;report personal property(money) of worker
  report sum [money] of worker
end

to-report total-money-of-thief                     ;;report personal property(money) of thief
  report sum [money] of thief
end

to-report total-money-of-police                    ;;report personal property(money) of police
  report sum [money] of police
end

to-report total-money                              ;;report personal property(money) of all person(turtles)
  report sum[money]of turtles
end

to-report average-worker
  ifelse count worker = 0
  [report 0]
  [report mean[money]of worker]
end

to-report average-thief
  ifelse count thief = 0
  [report 0]
  [report mean[money]of thief]
end

to-report average-police
  ifelse count police = 0
  [report 0]
  [report mean[money]of police]
end

to-report average-all
  ifelse count turtles = 0
  [report 0]
  [report mean[money]of turtles]
end
@#$#@#$#@
GRAPHICS-WINDOW
704
15
1173
505
25
25
9.0
1
10
1
1
1
0
1
1
1
-25
25
-25
25
0
0
1
ticks
30.0

BUTTON
22
82
85
115
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
218
182
395
215
police-pay
police-pay
0
20
3
1
1
NIL
HORIZONTAL

SLIDER
13
181
189
214
tax-rate
tax-rate
0
1
0.25
0.05
1
NIL
HORIZONTAL

SLIDER
218
129
393
162
career-change-tendency
career-change-tendency
0
100
70
1
1
NIL
HORIZONTAL

SLIDER
15
34
184
67
number-of-worker
number-of-worker
0
500
0
1
1
NIL
HORIZONTAL

SLIDER
426
130
600
163
job-ratio
job-ratio
0
100
51
1
1
NIL
HORIZONTAL

BUTTON
118
82
181
115
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
11
357
211
507
Wealth distribution
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -14454117 true "" "plot total-money-of-worker"
"pen-1" 1.0 0 -10402772 true "" "plot total-money-of-police"
"pen-2" 1.0 0 -2674135 true "" "plot total-money-of-thief"
"pen-3" 1.0 0 -16777216 true "" "plot total-money"

SWITCH
218
81
387
114
show-money?
show-money?
0
1
-1000

PLOT
227
357
427
507
career distribution
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"pen-1" 1.0 0 -14070903 true "" "plot count worker"
"pen-2" 1.0 0 -2674135 true "" "plot count thief"
"pen-3" 1.0 0 -10402772 true "" "plot count police"
"pen-4" 1.0 0 -16777216 true "" "plot count turtles"

SLIDER
13
128
188
161
living-expense
living-expense
0
10
3
1
1
NIL
HORIZONTAL

PLOT
449
356
649
506
Average Wealth
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"pen-0" 1.0 0 -13791810 true "" "plot average-worker"
"pen-1" 1.0 0 -2674135 true "" "plot average-thief"
"pen-2" 1.0 0 -10402772 true "" "plot average-police"
"pen-3" 1.0 0 -16777216 true "" "plot average-all"

SLIDER
425
181
598
214
fair-factor
fair-factor
0.1
5
1
0.1
1
NIL
HORIZONTAL

SWITCH
17
279
187
312
thief-escape-mode?
thief-escape-mode?
0
1
-1000

SLIDER
220
280
393
313
thief-vision
thief-vision
0
10
0
1
1
NIL
HORIZONTAL

SWITCH
16
230
187
263
catastrophe-mode?
catastrophe-mode?
1
1
-1000

SLIDER
219
230
394
263
catastrophe-probability
catastrophe-probability
0
100
100
1
1
NIL
HORIZONTAL

SLIDER
423
231
601
264
rebuild-probability
rebuild-probability
0
100
100
1
1
NIL
HORIZONTAL

SLIDER
216
34
388
67
number-of-thief
number-of-thief
0
500
0
1
1
NIL
HORIZONTAL

SLIDER
426
34
599
67
number-of-police
number-of-police
0
500
0
1
1
NIL
HORIZONTAL

SWITCH
427
84
597
117
visualize-job-salary?
visualize-job-salary?
0
1
-1000

@#$#@#$#@
## WHAT IS IT?

This model shows how a given society's criminal activities are influenced by police policies(tax rate and police salary). The model allows user to set the parameters of a society, including living expense, job ratio, fair factor and tendency to change career.
The user can observe the collective wealth, avreage wealth and career distribution of each kind of characters in society.This model explores three extensions.First is simulate the situation thief can escape from police, second is introduce catastrophe to societ and lastly is HubNet model.

## HOW IT WORKS

If I am a worker:
If my salary is enough for living, I will work here and get money, then I pay tax, otherwise I will search job, I keep moving until I find a patch without anyone else
Rules to switch career/job:
If my salary is lower than living expense, I will become a thief
Otherwise I have 70% chance to change job and 30% to change career.
If I choose to change career, first if my job salary lower than police pay, I will become police
Otherwise if average worker wealth is lower than average thief wealth, I will become thief.

If I am a police:
I first see if there is some thief around me, if so, punish him by taking half of his money
Then I walk around 
Rules to switch career:
Then I have chance to change my career: If I find a job with higher salary than police pay, I become a worker and work here.
Otherwise I check average worker wealth and average thief wealth, I will become the higher one if it is also higher than police pay. 

If I am a thief:
I first see if there is some worker around me, if so, grab half of his money
Then I walk around 
Rules to switch career:
Then I have chance to change my career if my money is less than average wealth of worker of police. If I decide change career, I will become the one with higher average wealth. 

Lastly, there is one rule for the society as a whole: when everyone dies, the system stops. Notice in case of user want to try HubNet with zero initial population, current the system is set to stop if population is zero after 150 ticks.This time is long enough for user join.

## HOW TO USE IT

Setup:set up the initial population and job distributed
GO: Starts and stops the model.

The input parameters of this model can be divided into two parts roughly: the setting of a society(initial population of each breed, job ratio, fair factor, people's tendency of changing career) and the policies of the society(police pay and tax rate). 

Regarding of the setting of a society:
1.number-of-worker, number-of-thief-number-of-police
As  their name implies, they are the initial population of each character. These parameters have to be set before running "set up" procedure. Changing them after press "go" button has no effect. 
2.job-ratio
The higher this value, the more jobs in the world.
3.fair-factor
The higher this value, the more fairly salary is distributed.
4.living expense
The basic living expense that everyone needs to spend each tick. 
5.career-change-tendency
The probability for everyone to change their career. 

Regarding of the policies 
1.police-pay
The salary police expects to get each tick. But police has no guarantee to get this salary unless government collects enough tax
2.tax-rate
The ratio needs to take away from worker's salary. Tax rate is used for paying police.

Lastly, There is one rule for the society as a whole: when everyone dies, the system stops.

## THINGS TO NOTICE

Run the model with the default settings.Watch the plots at the bottom. What kind of career distribution and wealth distribution you see and is this the same as you expected?

## THINGS TO TRY
Change tax rate and police pay to different values and see what will happend. Is the effect the same as you expected? After familiar with the model, set police pay as 4 and tax rate 0.25 (other values are welcomed to try if interested), then try to change the slider to any you society you can find data in real life, and observe whether the result matches. Also mental expirements is highly recommended, user can set certain extreme society context or policies to see the result. 

## EXTENDING THE MODEL

There are other policies which can influence criminal polices, such as welfare. 
Also other features of society can be further explored. 

## NETLOGO FEATURES
Breeds are used to represent the two different kinds of agents. The turtles primitive is used to refer to both breeds together.
Using HubNet to allow user get involved into the model. 

## RELATED MODELS

Did not find yet.

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0.4
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="police-pay-on-worker-money" repetitions="10" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <metric>sum[money]of turtles</metric>
    <steppedValueSet variable="police-pay" first="0" step="2" last="50"/>
  </experiment>
  <experiment name="tax-rate-on-money-case1" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <metric>sum[money]of turtles</metric>
    <enumeratedValueSet variable="visualize-job-salary?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="rebuild-probability">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="number-of-police">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="job-ratio">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="fair-factor">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="living-expense">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="thief-escape-mode?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="show-money?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="catastrophe-mode?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="number-of-thief">
      <value value="0"/>
    </enumeratedValueSet>
    <steppedValueSet variable="tax-rate" first="0" step="0.1" last="1"/>
    <enumeratedValueSet variable="catastrophe-probability">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="number-of-worker">
      <value value="250"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="career-change-tendency">
      <value value="70"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="police-pay">
      <value value="4"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="thief-vision">
      <value value="0"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <metric>count turtles</metric>
    <enumeratedValueSet variable="visualize-job-salary?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="rebuild-probability">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="number-of-police">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="job-ratio">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="fair-factor">
      <value value="4.3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="living-expense">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="thief-escape-mode?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="show-money?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="catastrophe-mode?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="number-of-thief">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="tax-rate">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="catastrophe-probability">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="number-of-worker">
      <value value="250"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="career-change-tendency">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="police-pay">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="thief-vision">
      <value value="0"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="police-pay-one-career-distribution" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <metric>count turtles</metric>
    <enumeratedValueSet variable="visualize-job-salary?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="rebuild-probability">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="number-of-police">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="job-ratio">
      <value value="70"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="fair-factor">
      <value value="0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="living-expense">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="thief-escape-mode?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="show-money?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="catastrophe-mode?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="number-of-thief">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="tax-rate">
      <value value="0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="catastrophe-probability">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="number-of-worker">
      <value value="250"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="career-change-tendency">
      <value value="70"/>
    </enumeratedValueSet>
    <steppedValueSet variable="police-pay" first="0" step="2" last="50"/>
    <enumeratedValueSet variable="thief-vision">
      <value value="0"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="police-pay-on-wealth" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <metric>sum[money]of turtles</metric>
    <enumeratedValueSet variable="visualize-job-salary?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="rebuild-probability">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="number-of-police">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="job-ratio">
      <value value="70"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="fair-factor">
      <value value="0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="living-expense">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="thief-escape-mode?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="show-money?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="catastrophe-mode?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="number-of-thief">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="tax-rate">
      <value value="0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="catastrophe-probability">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="number-of-worker">
      <value value="250"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="career-change-tendency">
      <value value="70"/>
    </enumeratedValueSet>
    <steppedValueSet variable="police-pay" first="0" step="2" last="20"/>
    <enumeratedValueSet variable="thief-vision">
      <value value="0"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="fair-factor-thief" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <metric>count thief</metric>
    <enumeratedValueSet variable="visualize-job-salary?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="rebuild-probability">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="number-of-police">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="job-ratio">
      <value value="50"/>
    </enumeratedValueSet>
    <steppedValueSet variable="fair-factor" first="0.1" step="0.2" last="5"/>
    <enumeratedValueSet variable="living-expense">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="thief-escape-mode?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="show-money?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="catastrophe-mode?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="number-of-thief">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="tax-rate">
      <value value="0.25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="catastrophe-probability">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="number-of-worker">
      <value value="250"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="career-change-tendency">
      <value value="70"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="police-pay">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="thief-vision">
      <value value="0"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="fair-factor-worker" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <metric>count worker</metric>
    <enumeratedValueSet variable="visualize-job-salary?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="rebuild-probability">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="number-of-police">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="job-ratio">
      <value value="50"/>
    </enumeratedValueSet>
    <steppedValueSet variable="fair-factor" first="0.1" step="0.2" last="5"/>
    <enumeratedValueSet variable="living-expense">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="thief-escape-mode?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="show-money?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="catastrophe-mode?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="number-of-thief">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="tax-rate">
      <value value="0.25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="catastrophe-probability">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="number-of-worker">
      <value value="250"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="career-change-tendency">
      <value value="70"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="police-pay">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="thief-vision">
      <value value="0"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="fair-factor-police" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <metric>count police</metric>
    <enumeratedValueSet variable="visualize-job-salary?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="rebuild-probability">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="number-of-police">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="job-ratio">
      <value value="50"/>
    </enumeratedValueSet>
    <steppedValueSet variable="fair-factor" first="0.1" step="0.2" last="5"/>
    <enumeratedValueSet variable="living-expense">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="thief-escape-mode?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="show-money?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="catastrophe-mode?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="number-of-thief">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="tax-rate">
      <value value="0.25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="catastrophe-probability">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="number-of-worker">
      <value value="250"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="career-change-tendency">
      <value value="70"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="police-pay">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="thief-vision">
      <value value="0"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
BUTTON
89
214
152
247
up
NIL
NIL
1
T
OBSERVER
NIL
NIL

BUTTON
88
298
151
331
down
NIL
NIL
1
T
OBSERVER
NIL
NIL

BUTTON
13
256
76
289
left
NIL
NIL
1
T
OBSERVER
NIL
NIL

BUTTON
164
260
227
293
right
NIL
NIL
1
T
OBSERVER
NIL
NIL

SLIDER
45
20
217
53
step-size
step-size
0
10
2
1
1
NIL
HORIZONTAL

MONITOR
99
81
156
130
location
NIL
3
1

VIEW
317
20
737
440
0
0
0
1
1
1
1
1
0
1
1
1
-25
25
-25
25

MONITOR
27
81
84
130
career
NIL
3
1

BUTTON
15
366
110
399
become-worker
NIL
NIL
1
T
OBSERVER
NIL
NIL

BUTTON
227
367
309
400
become-thief
NIL
NIL
1
T
OBSERVER
NIL
NIL

BUTTON
124
365
216
398
become-police
NIL
NIL
1
T
OBSERVER
NIL
NIL

MONITOR
169
81
239
130
police-pay
NIL
3
1

MONITOR
250
82
309
131
tax-rate
NIL
3
1

MONITOR
26
145
113
194
worker-wealth
NIL
3
1

MONITOR
121
145
195
194
thief-wealth
NIL
3
1

MONITOR
214
146
293
195
police-wealth
NIL
3
1

@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
