extensions [ nw ]

turtles-own [
  ;; facebook data
  id
  name
  centrality
  
  ;; infection variables
  infected?
  
  heard-from
  
]

directed-link-breed [tests test]

links-own [
  weight
]

to load-graph
  clear-all  
  
  ;; Hard-code your path if you don't want to get prompted every time:
  ;; let filename user-file "/path/to/your-network.graphml"
  let filename user-file
  
  if (filename != false) [
    nw:load-graphml filename [
      set infected? false
      set shape "circle"
    ]
    nw:set-context turtles links
  ]
  let no-of-components length (sentence nw:weak-component-clusters)
  ifelse no-of-components > 0 [let degrees-separated 360 / no-of-components
    let counter 0
    foreach nw:weak-component-clusters [
      let biggest-component-size max map [count ?] nw:weak-component-clusters
      if count ? != biggest-component-size [ask turtle-set ? [die]]
    ]
    reset-ticks
  ]
  [
    user-message "No network was loaded, please try again."
  ]

end

to remove-most-central
  ask max-one-of turtles [ count my-links ] [ die ]
  nw:set-context turtles links
end

to update-layout
  layout-spring turtles links 0.2 .1 1
end

to toggle-labels
  ;; if any have a label, turn off all labels
  ifelse any? turtles with [label != ""]
  [
    ask turtles [set label ""]
  ]
  [
    let the-number-of-turtles count turtles * (100 - label-threshold) / 100
    ask max-n-of the-number-of-turtles turtles [size] [set label name]
  ]
  
end

to calc-centrality
  if centrality-measure = "random" [
    ask turtles [set size random 14 + 1]
    stop 
  ]
  if centrality-measure = "reset-size" [
    ask turtles [set centrality 1 set size 1]
    stop
  ]
  if centrality-measure = "degree-centrality" [
    ask turtles [set centrality count my-links]
    ask turtles [set size 10 * (normalize centrality min [centrality] of turtles max [centrality] of turtles)]
    stop
  ]
  let the-task (word "set centrality nw:" centrality-measure)
  ask turtles [run the-task]
  ask turtles [set size 10 * (normalize centrality min [centrality] of turtles max [centrality] of turtles)]

end

;; -------------------------------- ;;
;; New code for the infection logic ;;
;; -------------------------------- ;;

globals [
  max-infections                ;; number of people that you can infect
  points                        ;; number of points 
  current-payoff
  last-infected
]

to setup
  clear-all-plots

  ask turtles [
    set infected? false 
    set label "" 
    set color white
    set size 3
  ]
  
  ask links [
    set thickness 1
    set color grey
  ]
  
  set last-infected nobody
    
  ;; set current pay off to 100
  set current-payoff 100

  ;; this is the maximum number of turtles the user can 
  ;; infect before the model runs  
  set max-infections 5

  reset-ticks
end

to undo
  ask last-infected [
    set infected? false
    set color white
    set current-payoff 100
   ]
  show (word [name] of last-infected " did not hear the rumor!")
end

to touch-infect
  let the-patch patch mouse-xcor mouse-ycor
  if mouse-down? and any? [turtles-here] of the-patch [
    ask one-of [turtles-here] of the-patch [infect-me-initially]
    stop
  ]

end

to go
  tick
  infect
  ;; count down on current-payoff to keep track of points
  set current-payoff current-payoff * .9
  ;; if all infected, stop  
  if all? turtles [ infected? ] [ stop ]
  wait 2
end

to infect
  ask turtles with [ infected? ] [    
    ;; infect at probability .5
    ask link-neighbors with [ not infected? ] [
        if random-float 100 < chance-of-spread [
        set heard-from myself
        
        ask link-with myself [
          set color pink
          set thickness 1
        ]
        
        infect-me
      ]
    ]
  ]
end

;; initial infection procedures

to infect-by-centrality
  ifelse centrality-measure = "random" 
    [ ask one-of turtles with [ not infected? ] 
      [infect-me-initially]
    ]
    [ 
      calc-centrality
      ask max-one-of turtles with [ not infected? and centrality != false] [ centrality ] [
        infect-me-initially
      ] 
    ]
end

to infect-by-name  
  
  let the-named-turtles turtles with [member? person-name name and not infected?]
  if count the-named-turtles > 10 [
    user-message "There are too many people with that name. Be more specific."
    stop
  ]
  if count the-named-turtles > 1
    [
      let the-name user-one-of "Which person do you want to tell?" [name] of the-named-turtles
      ask one-of turtles with [name = the-name][infect-me-initially]
    ]
  if count the-named-turtles = 1
    [
      ask the-named-turtles [infect-me-initially]
    ]
  if count the-named-turtles = 0 [
    user-message (word "Either there is no person named \"" person-name "\" or they already heard the rumor.")
  ]
end


to update-color
  ifelse infected?
    [ set color red ]
    [ set color blue ]
end

to infect-me-initially
  ifelse count turtles with [ infected? ] < max-infections [
    infect-me
    set heard-from "you"
    set points 0
    show (word "You told " name " the rumor!")
  ]
  [
    user-message "You have already told five people. Start the model now."
  ]
end

to infect-me
  set infected? true
  set color red
  set size 3
  set points points + current-payoff  
  set last-infected self
end

; this normalizes a number
to-report normalize [value the-min the-max]
  set the-min ifelse-value (the-min = 0) [.001] [the-min]
  let normalized (value - the-min) / (the-max - the-min)
  report normalized
end

to kill-smaller-components
  let the-component []
  foreach nw:weak-component-clusters [
    if length ? > length the-component [set the-component ?]
  ]

  set the-component (turtle-set the-component)
  show count the-component
  ask turtles with [not member? self the-component] [die]
end


;; turtle procedure
to show-centralities
  show (word "Name: " name ", degree: " count my-links ", betweenness: " nw:betweenness-centrality ", closeness: " nw:closeness-centrality ", eigenvector:" nw:eigenvector-centrality ", page-rank: " nw:page-rank)
end

;; THE FOLLOWING PROCEDURES ONLY WORK AFTER THE RUMOR MODEL HAS RUN ITS COURSE

;; turtle procedure that shows who a turtle heard it all from
to-report show-rumor-path
  let rumor-path (list)
  report (word name " heard it from " reduce word show-rumor rumor-path)
end

;; helper procedure for above procedure
to-report show-rumor [rumor-path]
  if heard-from != nobody[
    set rumor-path lput (word [name] of heard-from ", who heard it from ") rumor-path
    report [show-rumor rumor-path] of heard-from
  ]
  report lput " you!" rumor-path
end

;; turtle procedure that returns a LIST (rather than string like the procedures above) of who told whom
to-report the-rumor-path-list
  let rumor-path (list self)
  report show-rumor-list rumor-path
end

;; helper for above
to-report show-rumor-list [rumor-path]
  ifelse heard-from != "you" [
    set rumor-path lput heard-from rumor-path
    report [show-rumor-list rumor-path] of heard-from
  ]
  [
    report rumor-path
  ]  
end

;; observer procedure that breaks apart the graph and reconstructs a graph based on who heard the rumor from whom.
to illustrate-rumor-paths
  ;; resize all turtles
  ask turtles [set size 3 set label ""]
  ;; only do this if we have run the model and all turtles have it the rumor
  if any? turtles with [not infected?] [
    user-message "You can't do this until you have run the model."
    stop
  ]
  ;; get all the rumor paths
  let the-rumor-paths [the-rumor-path-list] of turtles
  ask links [die]
  ;; iterate over them 
  foreach the-rumor-paths [
    let the-rumor ?
    ;; ask the last turtle in each rumor list to show their name - that is the person that the learner told initially
    ask last the-rumor [set label name]
    ;; build links
    while [length the-rumor >= 2][
      ask item 1 ? [create-link-to item 0 ?]
      set the-rumor butfirst the-rumor
    ]
  ]
end

;; this reports those who only heard the rumor but never told anyone
to-report last-to-hear
  report turtles with [count my-out-links = 0]
end

;; this reports those that heard it from the those who were intitially told 
to-report first-to-hear
  report turtle-set [out-link-neighbors] of initially-infected
end

;; this reports those that heard it from the learner
to-report initially-infected
  report turtles with [count my-in-links = 0]
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Layouts
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to redo-layout [ forever? ]
  repeat ifelse-value forever? [ 1 ] [ 50 ] [
    layout-spring turtles links 1 (80 / 1) (1 / 1)
    display
    if not forever? [ wait 0.005 ]
  ]
end

to layout-once
  redo-layout false
end

to spring-forever
  redo-layout true
end
@#$#@#$#@
GRAPHICS-WINDOW
600
10
1191
622
145
145
2.0
1
10
1
1
1
0
0
0
1
-145
145
-145
145
1
1
1
ticks
30.0

MONITOR
160
230
595
275
Number of people to tell:
max (list (max-infections - count turtles with [infected?]) 0)
0
1
11

BUTTON
160
10
595
55
NIL
load-graph\n
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

CHOOSER
255
70
450
115
centrality-measure
centrality-measure
"degree-centrality" "page-rank" "betweenness-centrality" "eigenvector-centrality" "closeness-centrality" "reset-size" "random"
0

BUTTON
385
335
595
376
Tell someone based on Centrality
infect-by-centrality
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
385
275
595
335
Tell this person
infect-by-name
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
385
430
595
475
Score
points / count turtles
10
1
11

BUTTON
160
430
385
475
GO!
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
160
475
595
595
People who heard the Rumor
Time
Infected turtles
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot count turtles with [infected?]"

BUTTON
160
70
255
155
Update Layout
spring-forever
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
160
170
290
215
Setup Rumor Model
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
450
70
595
120
Toggle Labels
toggle-labels
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
450
120
595
153
label-threshold
label-threshold
0
100
80
1
1
%
HORIZONTAL

BUTTON
255
115
450
155
Adjust Size of Nodes
calc-centrality\n\n
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

TEXTBOX
10
10
160
46
1. Import your Social Network
15
0.0
1

TEXTBOX
10
105
110
123
2. Visualize it
15
0.0
1

TEXTBOX
10
175
125
211
3. Set up Rumor Model
15
0.0
1

TEXTBOX
10
230
160
266
4. Tell your Friends
15
0.0
1

TEXTBOX
10
430
160
448
5. Spread the Word
15
0.0
1

CHOOSER
160
330
385
375
centrality-measure
centrality-measure
"degree-centrality" "page-rank" "betweenness-centrality" "eigenvector-centrality" "closeness-centrality" "random" "reset-size"
0

TEXTBOX
10
55
595
73
---------------------------------------------------------------------------------------------------------------------------- 
11
0.0
1

TEXTBOX
10
155
595
173
---------------------------------------------------------------------------------------------------------------------------- 
11
0.0
1

TEXTBOX
10
215
595
233
---------------------------------------------------------------------------------------------------------------------------- 
11
0.0
1

TEXTBOX
0
415
600
433
---------------------------------------------------------------------------------------------------------------------------- 
11
0.0
1

BUTTON
160
375
385
415
By 'touch'
touch-infect
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
385
375
595
415
Undo last 'whisper'
undo
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

INPUTBOX
160
275
385
335
person-name
Weintrop
1
0
String

BUTTON
160
595
380
640
Show rumor network
illustrate-rumor-paths\n
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
380
595
595
640
Layout Rumor Network
display \nrepeat 3 [layout-spring turtles links 1 (10 / 1) (10 / 1)]
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
290
170
460
215
Save your Network
export-world \"RumorModelSetup\"
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
460
170
595
215
Load your Network
import-world \"RumorModelSetup\"
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
5
475
155
508
chance-of-spread
chance-of-spread
0
100
100
1
1
%
HORIZONTAL

@#$#@#$#@
## WHAT IS IT?

This model allows you to import social network data, and explore how a rumor might spread on it.

## HOW IT WORKS

The rules are simple: you want to spread a rumor as fast as possible to everyone in your social network. To get the rumor started, you get to 'whiper' the rumor to five people. For every 'tick', they then have a 50% chance of telling each person they know. 

The faster the rumor spreads, the more points you get. Specifically, the payoff you get for telling people drops by 10% for every tick. So make sure you initially whisper the rumor to people who, because of their location in your network, can spread the rumor as fast as possible!

## HOW TO USE IT

Press LOAD-GRAPH first to import your data. 

The widgets near the "Visualize it!" heading allow you to visually explore your network. You can set the size of nodes based on their various centralities, and you can show labels for those nodes that are in the highest percet, set by the LABEL-THRESHOLD slider. If you want to see a prettier, layouted version of your network, press the "Layout" button.

Click the SETUP RUMOR MODEL button to start spreading the rumor in your network.

You can infect people in various ways; by their specific name, by having the model tell someone based on their network centrality, and by 'touching' them. If you want to infect people by touching them, you have to click the "BY TOUCH" button" first.

Finally, click the GO button to start spreading the rumor. When everybody has heard the rumor, the model will automatically stop. The plot will show you how many people heard the rumor, and the SCORE monitor will tell you how well you did.

If you want to see a network representation of who told whom, click the SHOW RUMOR NETWORK button. This will show you how the rumor spread from each of the five people that you initialy told.

## THINGS TO NOTICE

Running the model more than once may (and probably will) yield different results. This is because there is some randomness in how the rumor spreads.

## CREDITS AND REFERENCES

Know Your Network. Arthur Hjorth, David Weintrop, Uri Wilensky 2014.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.1.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
1
@#$#@#$#@
